# AISSI POC
This project implements a proof-of-concept system using AISSI standard Interfaces. It consists of AI, Strategy, and Simulation that interact via OpenAPI.

![Sequence Diagram](./sequence_diagram_POC.png) 

## Motivation
The goal is to explore and demonstrate the capabilities of the defined Interfaces. This architecture enables easy experimentation and extension of the system.

## Installation

### Option 1: Fast Installation via Anaconda
Prerequisites:
- [Anaconda](https://www.anaconda.com/download) 
- [Java](https://www.java.com/de/download/)

Steps:
1. Create a new Anaconda environment:
   conda create --name AISSI_POC python=3.12.3

2. Activate the environment in your working folder:
   execute start_AISSI_POC_env.bat

3. Install Python dependencies:
   pip install -r requirements.txt

4. Generate and install OpenAPI server and client code:
   execute Generator\Total_generation.bat

### Option 2: Manual Installation
Prerequisites:
- [Java](https://www.java.com/de/download/)
- Python 3.12.3

Steps: 
1. Install Python dependencies:
   pip install -r requirements.txt

2. Generate OpenAPI servers:
   java -jar .\openapi-generator-cli-7.1.0.jar batch config-flask-server-ai.yaml
   java -jar .\openapi-generator-cli-7.1.0.jar batch config-flask-server-strategy.yaml

3. Generate OpenAPI clients:
   java -jar .\openapi-generator-cli-7.1.0.jar batch config-client-sim.yaml 
   java -jar .\openapi-generator-cli-7.1.0.jar batch config-client-ai.yaml
   java -jar .\openapi-generator-cli-7.1.0.jar batch config-client-strategy.yaml 

4. Install OpenAPI server and client packages:
   pip install -e .\client_strategy\
   pip install -e .\client_ai\
   pip install -e .\client_sim\
   pip install -e .\server_strategy\
   pip install -e .\server_ai\


## Usage
1. Run the Simulation component:
   Execute "Simulator\D-SIMCON-SIM-ADAPTER.exe"

2. In a separate terminal, run the AI component:
   python AISSI_POC_AI.py

3. In another terminal, run the Strategy component:
   python AISSI_POC_Strategy.py 


The OpenAPI server UIs can be accessed at:
- Strategy: http://localhost:5000/aissi/strategy/adapter/api/v1/ui/  
- AI: http://localhost:5001/aissi/ai/adapter/api/v1/ui/
- Simulation: http://localhost:8772/aissi/simulation/adapter/api/v1/ui/

## Architecture Overview
The system consists of three main components:

- **AI**: Implements decision algorithms to make decisions based on simulation states
- **Strategy**: Coordinates the AI and Simulation
- **Simulation**: Provides the environments

These components communicate via HTTP using OpenAPI specifications. The `Generator` folder contains the OpenAPI definitions and tooling to generate the server and client code.

## License
Apache 2.0

This project leverages the OpenAPI Generator tool, which is licensed under the Apache 2.0 License.  See [https://github.com/OpenAPITools/openapi-generator/blob/master/LICENSE](https://github.com/OpenAPITools/openapi-generator/blob/master/LICENSE) for details.


## Contact
For questions or comments, please contact the Creators:
- Tobias Bosse (tobias.bosse@de.bosch.com)


# Acknowledgement
This work has received funding from the Eureka ITEA-4 Cluster AI Call 2020 under grant agreement
no. 20212 (project AISSI – Autonomous Integrated Scheduling for Semiconductor Industry), which is
financially supported by the Federal Ministry for Economic Affairs and Climate Action in Germany and
Enterprise Singapore. This support is gratefully acknowledged.
http://www.aissi-project.com


# Publication
If you find this code useful, please cite:
Bosse, T., et al. "A STANDARD FRAMEWORK FOR AI-DRIVEN OPTIMIZATIONS IN VARIOUS COMPLEX DOMAINS." *Winter Simulation Conference (WSC)*, 2024.